use master
GO

set nocount on 

--set to 0 to skip updating the A4Panel_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @PanelClientPayload01 nvarchar(max) = N'
-- DEV-92049 
--------------------------------------------------------------
-- VX_sp_GetPanelPerformance
--------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[VX_sp_GetPanelPerformance]'') AND type IN (N''P'', N''PC'')) 
   DROP PROCEDURE [dbo].[VX_sp_GetPanelPerformance]
'

declare @PanelClientPayload02 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[VX_sp_GetPanelPerformance]
    @panelId INT
AS
BEGIN
    SET NOCOUNT ON;

    DECLARE @Total INT = (SELECT COUNT(*) FROM [Panelists] WHERE Panel_Id = @panelId AND Status = 0);

    DECLARE @LastWeek DATETIME = DATEADD(WEEK, -1, GETUTCDATE())
    DECLARE @LastMonth DATETIME = DATEADD(MONTH, -1, GETUTCDATE())
    DECLARE @Last6Months DATETIME = DATEADD(MONTH, -6, GETUTCDATE())
    DECLARE @LastYear DATETIME = DATEADD(YEAR, -1, GETUTCDATE());

    SELECT p.id, LastInviteDate, LastCompletedDate
    INTO #p
    FROM Panelists p
    LEFT JOIN
        (SELECT panelistid invitePanelistId, MAX(datetime) LastInviteDate
        FROM ActivityHistories ah
            LEFT JOIN ActivityHistories_EmailActivityHistory email
                ON ah.Id = email.Id AND EmailInvitationStatus = 1
            LEFT JOIN ActivityHistories_SmsActivityHistory sms
                ON ah.id = sms.id AND SmsInvitationStatus = 1
        WHERE email.id IS NOT NULL OR sms.id IS NOT NULL
        GROUP BY panelistid) invite ON p.id = invitePanelistId
    LEFT JOIN
        (SELECT panelistid surveyPanelistId, MAX(datetime) LastCompletedDate
        FROM ActivityHistories ah
            INNER JOIN ActivityHistories_SurveyActivityHistory surveyAct
                ON ah.Id = surveyAct.Id AND DispositionCode = 1
        GROUP BY panelistid) surveyAct ON p.id = surveyPanelistId
    WHERE Panel_id = @Panelid AND Status = 0 AND (invitePanelistId IS NOT NULL OR surveyPanelistid IS NOT NULL)

    SELECT Total.[Type], Total.[Count] Total,
        ISNULL(LastWeek.[Count], 0) LastWeek,
        ISNULL(LastMonth.[Count], 0) LastMonth,
        ISNULL(Last6Months.[Count], 0) Last6Months,
        ISNULL(LastYear.[Count], 0) LastYear
    INTO #positive FROM
    (SELECT CASE WHEN LastCompletedDate IS NOT NULL THEN 2 ELSE 1 END [Type], COUNT(*) [Count]
        FROM #p GROUP BY CASE WHEN LastCompletedDate IS NOT NULL THEN 2 ELSE 1 END) Total
    LEFT JOIN
    (SELECT CASE WHEN LastCompletedDate >= @LastWeek THEN 2 ELSE 1 END [Type], COUNT(*) [Count]
        FROM #p WHERE LastCompletedDate >= @LastWeek OR LastInviteDate >= @LastWeek
        GROUP BY CASE WHEN LastCompletedDate >= @LastWeek THEN 2 ELSE 1 END) LastWeek ON Total.[Type] = LastWeek.[Type]
    LEFT JOIN
    (SELECT CASE WHEN LastCompletedDate >= @LastMonth THEN 2 ELSE 1 END [Type], COUNT(*) [Count]
        FROM #p WHERE LastCompletedDate >= @LastMonth OR LastInviteDate >= @LastMonth
        GROUP BY CASE WHEN LastCompletedDate >= @LastMonth THEN 2 ELSE 1 END) LastMonth ON Total.[Type] = LastMonth.[Type]
    LEFT JOIN
    (SELECT CASE WHEN LastCompletedDate >= @Last6Months THEN 2 ELSE 1 END [Type], COUNT(*) [Count]
        FROM #p WHERE LastCompletedDate >= @Last6Months OR LastInviteDate >= @Last6Months
        GROUP BY CASE WHEN LastCompletedDate >= @Last6Months THEN 2 ELSE 1 END) Last6Months ON Total.[Type] = Last6Months.[Type]
    LEFT JOIN
    (SELECT CASE WHEN LastCompletedDate >= @LastYear THEN 2 ELSE 1 END [Type], COUNT(*) [Count]
        FROM #p WHERE LastCompletedDate >= @LastYear OR LastInviteDate >= @LastYear
        GROUP BY CASE WHEN LastCompletedDate >= @LastYear THEN 2 ELSE 1 END) LastYear ON Total.[Type] = LastYear.[Type];

    SELECT [Name],
        CASE
            WHEN @Total = 0 THEN ''0 (0%)''
            ELSE CAST(ISNULL(Total, 0) AS VARCHAR(20)) + '' ('' + CAST(ROUND(CAST(ISNULL(Total, 0) AS FLOAT) * 100.0 / @Total, 1) AS VARCHAR(20)) + ''%)''
        END AS Total,
        ISNULL(LastWeek, 0) AS LastWeek,
        ISNULL(LastMonth, 0) AS LastMonth,
        ISNULL(Last6Months, 0) AS LastSixMonths,
        ISNULL(LastYear, 0) AS LastYear
    FROM (VALUES (2, ''Invited AND completed a survey''), (1, ''Invited AND did not complete a survey'')) AS v([Type], [Name])
    LEFT JOIN #positive ON v.[Type] = #positive.[Type]
    UNION ALL
    SELECT ''Not been invited to a do survey in the.'' [Name],
        CASE
            WHEN @Total = 0 THEN ''0 (0%)''
            ELSE CAST((@Total - ISNULL(SUM(Total), 0)) AS VARCHAR(20)) + '' ('' + CAST(ROUND((CAST(@Total AS FLOAT) - ISNULL(SUM(Total), 0)) * 100.0 / @Total, 1) AS VARCHAR(20)) + ''%)''
        END AS Total,
        @Total - ISNULL(SUM(LastWeek), 0) AS LastWeek,
        @Total - ISNULL(SUM(LastMonth), 0) AS LastMonth,
        @Total - ISNULL(SUM(Last6Months), 0) AS LastSixMonths,
        @Total - ISNULL(SUM(LastYear), 0) AS LastYear
    FROM #positive;

    DROP TABLE #positive;
    DROP TABLE #p;
END
'

declare @PanelClientPayload03 nvarchar(max) = N'
--------------------------------------------------------------
-- VX_sp_SetPanelPerformanceCustomDateFilter
--------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[VX_sp_SetPanelPerformanceCustomDateFilter]'') AND type IN (N''P'', N''PC'')) 
   DROP PROCEDURE [dbo].[VX_sp_SetPanelPerformanceCustomDateFilter]
'

declare @PanelClientPayload04 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[VX_sp_SetPanelPerformanceCustomDateFilter] 
 @panelId int,
 @fromDate datetime,
 @toDate datetime
AS
BEGIN
    SET NOCOUNT ON;

    DECLARE @Total INT = (SELECT COUNT(*) FROM [Panelists] WHERE Panel_Id = @panelId AND Status = 0);

    SET @toDate = DATEADD(DAY, +1, @toDate);

    SELECT p.id, invitePanelistId, surveyPanelistid
    INTO #p
    FROM Panelists p
    left join
        (select distinct panelistid invitePanelistId
        from ActivityHistories ah
            left join ActivityHistories_EmailActivityHistory email on ah.Id = email.Id and EmailInvitationStatus = 1
            left join ActivityHistories_SmsActivityHistory sms on ah.id = sms.id and SmsInvitationStatus = 1
        where datetime >= @fromDate and datetime <= @toDate
			and (email.id is not null or sms.id is not null)) invite on p.id = invitePanelistId
    left join
        (select distinct panelistid surveyPanelistId
        from ActivityHistories ah
            inner join ActivityHistories_SurveyActivityHistory surveyAct on ah.Id = surveyAct.Id and DispositionCode = 1
		where datetime >= @fromDate and datetime <= @toDate) surveyAct on p.id = surveyPanelistId
    where Panel_id = @Panelid and Status = 0 and (invitePanelistId is not null or surveyPanelistid is not null)

    SELECT [Type], CustomFilter.[Count] CustomFilter
    INTO #positive
	FROM
    (SELECT CASE WHEN surveyPanelistid IS NOT NULL THEN 2 ELSE 1 END [Type], COUNT(*) [Count]
         FROM #p GROUP BY CASE WHEN surveyPanelistid IS NOT NULL THEN 2 ELSE 1 END) CustomFilter;

    SELECT [Name], ISNULL(CustomFilter,0) CustomFilter
	FROM (VALUES (2, ''Invited AND completed a survey''), (1, ''Invited AND did not complete a survey'')) AS v([Type], [Name])
	LEFT JOIN #positive ON v.[Type] = #positive.[Type]
    UNION ALL
    SELECT ''Not been invited to a do survey in the.'' [Name], @Total-ISNULL(SUM(CustomFilter),0)
	FROM #positive

    DROP TABLE #positive
    DROP TABLE #p
END
'

declare @PanelClientPayload05 nvarchar(max) = N'
-- DEV-92050
---------------------------
-- VX_sp_GetPanelSurveys
---------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[VX_sp_GetPanelSurveys]'') AND type IN (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[VX_sp_GetPanelSurveys]
'

declare @PanelClientPayload06 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[VX_sp_GetPanelSurveys]
    @panelId int,
    @showInactive bit,
    @userId int,
    @search NVARCHAR(255) = '''',
    @sort NVARCHAR(255) = '''',
    @sortColumn NVARCHAR(50) = '''',
    @sortDirection NVARCHAR(5),
    @startIndex INT = 1,
    @endIndex INT = 10
AS
BEGIN
    SET NOCOUNT ON

    DECLARE @panelDatabase nvarchar(64) = DB_NAME()
    DECLARE @clientId int = dbo.GetClientId(@panelDatabase)
    DECLARE @clientIdString nvarchar(8) = CONVERT(nvarchar, @clientId)
    DECLARE @surveyDatabase nvarchar(40) = ''A4Survey_Client_'' + @clientIdString

    DECLARE @stmt nvarchar(MAX)
    DECLARE @innerQuery nvarchar(MAX)
    DECLARE @surveyId int
    DECLARE @surveySchema nvarchar(50)

    CREATE TABLE #tblPanelSurveys
    (
        [SurveyId] int NOT NULL PRIMARY KEY,
        [LastAccessed] datetime NULL
    )

    DECLARE SurveysCursor CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR
    SELECT [SurveyId]
    FROM [dbo].[PanelSurveyStatistics] WITH(NOLOCK)
    WHERE [PanelId] = @panelId

    OPEN SurveysCursor
    FETCH NEXT FROM SurveysCursor INTO @SurveyId

    WHILE @@FETCH_STATUS = 0
    BEGIN
        SET @surveySchema = ''Survey_'' + @clientIdString + ''_'' + CONVERT(nvarchar, @surveyId)
        SET @stmt = ''
            USE ['' + @surveyDatabase + '']
            IF SCHEMA_ID(@surveySchema) IS NOT NULL
            BEGIN
                INSERT INTO #tblPanelSurveys ([SurveyId], [LastAccessed])
                VALUES (
                    @surveyId,
                    (SELECT MAX([ResLastCallDate]) FROM ['' + @surveySchema + ''].[Respondent] WITH (NOLOCK))
                )
            END''
        EXEC sp_executesql @stmt, N''@surveyId int, @surveySchema nvarchar(50)'', @surveyId, @surveySchema
        FETCH NEXT FROM SurveysCursor INTO @SurveyId
    END

    CLOSE SurveysCursor
    DEALLOCATE SurveysCursor

    IF (@sort IS NULL OR LEN(@sort) <= 0 ) SET @sort = ''[Id]''
    IF (@sortColumn = ''PanelistResponseRate'') SET @sort = ''(PanelistCompleted / NULLIF(CAST(LinkedPanelists AS float), 0))'' + @sortDirection
    IF (@sortColumn = ''ParticipationRate'') SET @sort = ''(TotalParticipated / NULLIF(CAST(LinkedPanelists AS float), 0))'' + @sortDirection

    SET @innerQuery = ''(
        SELECT
            survey.Id,
            survey.Name,
            projectstats.Used AS TotalResponses,
            projectstats.Completed AS CompletedRespondent,
            #tblPanelSurveys.[LastAccessed], (
                SELECT SUM(pt.[Amount])
                FROM ['' + @panelDatabase + ''].[dbo].[PointsTransactions] pt WITH (NOLOCK)
				WHERE pt.[sourceId] = ps.[SurveyId] AND pt.[Source] = 0
            ) AS Points,
            ps.[Linked] AS LinkedPanelists,
            ps.[Completed] AS PanelistCompleted,
            (ps.[Linked] - ps.[Completed]) AS PanelistNotCompleted, (
                SELECT ISNULL(COUNT(*), 0)
                FROM ['' + @panelDatabase + ''].[dbo].[Samples] s WITH (NOLOCK)
                WHERE s.[PanelId] = ps.[PanelId] AND s.[SurveyId] = ps.[SurveyId] AND s.[Status] = 3
            ) AS LinkedSamples,
            ['' + @surveyDatabase + ''].[dbo].GetSurveyTotalActiveDays(survey.[Id]) AS TotalActiveDays,
            projectstats.[TotalSample] AS TotalCases,
            ps.[Participated] AS TotalParticipated,
            CAST(ROUND((ps.[Participated] / NULLIF(CAST(ps.[Linked] AS float), 0)) * 100, 0) AS varchar) + ''''%'''' AS ParticipationRate,
            CAST(ROUND((ps.[Completed] / NULLIF(CAST(ps.[Linked] AS float), 0)) * 100, 0) AS varchar) + ''''%'''' AS PanelistResponseRate
        FROM #tblPanelSurveys
        INNER JOIN ['' + @panelDatabase + ''].[dbo].[PanelSurveyStatistics] ps WITH (NOLOCK) ON #tblPanelSurveys.[SurveyId] = ps.[SurveyId]
        INNER JOIN ['' + @surveyDatabase + ''].[dbo].[Survey] survey WITH (NOLOCK) ON ps.[SurveyId] = survey.id
        INNER JOIN ['' + @surveyDatabase + ''].[dbo].[ProjectStatistics] projectstats WITH (NOLOCK) ON survey.Id = projectstats.ProjectId
        LEFT JOIN ['' + @surveyDatabase + ''].[dbo].VSM_fn_GetUserPermissions(@userId) perm
            ON perm.ObjectId = survey.Id AND ((ISNULL(perm.AllowedPermissions,0) & 1)=1 AND (ISNULL(perm.DeniedPermissions,0) & 1)=0 AND perm.ObjectTypeId IN (2,3))
        WHERE ps.[PanelId] = @panelId
            AND (@showInactive=1 OR survey.Status=3)
            AND (['' + @surveyDatabase + ''].[dbo].VSM_IsUserAdministrator(@userId) = 1 OR perm.ObjectId IS NOT NULL)
    ) AS subquery''

    SET @stmt = ''SELECT * FROM
    (SELECT ROW_NUMBER() OVER (ORDER BY '' + @sort + '') AS [RowNum], *
    FROM '' + @innerQuery + '' WHERE subquery.Name LIKE ''''%'' + @search + ''%'''') rowquery
    WHERE [RowNum] >= @startIndex AND [RowNum] <= @endIndex
    ORDER BY [RowNum]''

    EXEC sp_executesql @stmt, N''@panelId int, @showInactive bit, @userId int, @startIndex int, @endIndex int'', @panelId, @showInactive, @userId, @startIndex, @endIndex

    SET @stmt = ''SELECT COUNT(*) AS [TotalRecords] FROM '' + @innerQuery
    EXEC sp_executesql @stmt, N''@panelId int, @showInactive bit, @userId int'', @panelId, @showInactive, @userId

    IF @search <> ''''
    BEGIN
        SET @stmt = ''SELECT COUNT(*) AS [TotalDisplayedRecords] FROM '' + @innerQuery + '' WHERE Name LIKE ''''%'' + @search + ''%''''''
        EXEC sp_executesql @stmt, N''@panelId int, @showInactive bit, @userId int'', @panelId, @showInactive, @userId
    END

    DROP TABLE #tblPanelSurveys
END
'

declare @PanelClientPayload07 nvarchar(max) = N'
--------------------------------------------------------------
-- VX_sp_GetPanelSurveysTotal
--------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[VX_sp_GetPanelSurveysTotal]'') AND type IN (N''P'', N''PC'')) 
   DROP PROCEDURE [dbo].[VX_sp_GetPanelSurveysTotal]
'

declare @PanelClientPayload08 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[VX_sp_GetPanelSurveysTotal]
    @panelId int,
    @showInactive bit,
    @userId int
AS
BEGIN
    SET NOCOUNT ON

    DECLARE @panelDatabase nvarchar(64) = DB_NAME()
    DECLARE @clientId int = dbo.GetClientId(@panelDatabase)
    DECLARE @clientIdString nvarchar(8) = CONVERT(nvarchar, @clientId)
    DECLARE @surveyDatabase nvarchar(40) = ''A4Survey_Client_'' + @clientIdString
    DECLARE @stmt nvarchar(MAX) = ''SELECT
        COUNT(survey.Id) AS TotalSurveys,
        SUM(projectstats.Used) AS TotalResponses,
        SUM(projectstats.Completed) AS TotalCompletedRespondents, (
            SELECT SUM(pt.[Amount])
        ) AS TotalPoints,
        SUM(ps.[Linked]) AS TotalLinkedPanelists,
        SUM(projectstats.[TotalSample]) AS TotalSamples,
        SUM(ps.[Completed]) AS TotalPanelistsCompleted,
        SUM((ps.[Linked] - ps.[Completed])) AS TotalPanelistNotCompleted, (
            SELECT ISNULL(COUNT(*), 0)
            FROM ['' + @panelDatabase + ''].[dbo].[Samples] s WITH (NOLOCK)
            WHERE s.[PanelId] = @panelId AND s.[Status] = 3
        ) AS TotalLinkedSamples,
        SUM(projectstats.[TotalSample]) AS TotalCases,
        CAST(ROUND((SELECT (100 - ((SELECT ISNULL(COUNT(*), 0) FROM ['' + @panelDatabase + ''].[dbo].[Panelists] WITH (NOLOCK) WHERE [Panel_Id] = @panelId AND [Status] = 1 AND [ActivationCode] IS NOT NULL) / CAST((SELECT NULLIF(COUNT(*), 0) FROM ['' + @panelDatabase + ''].[dbo].[Panelists] WITH (NOLOCK) WHERE [Panel_Id] = @panelId AND [ActivationCode] IS NOT NULL) AS float)) * 100)), 0) AS varchar) + ''''%'''' AS OptIn
        FROM ['' + @panelDatabase + ''].[dbo].[PanelSurveyStatistics] ps WITH (NOLOCK)
        INNER JOIN ['' + @surveyDatabase + ''].[dbo].[Survey] survey WITH (NOLOCK) ON ps.[SurveyId] = survey.id
        INNER JOIN ['' + @surveyDatabase + ''].[dbo].[ProjectStatistics] projectstats WITH (NOLOCK) ON survey.Id = projectstats.ProjectId
		LEFT JOIN ['' + @panelDatabase + ''].[dbo].[Panelists] panelists WITH (NOLOCK) ON panelists.[Panel_Id] = @panelId
		LEFT JOIN ['' + @panelDatabase + ''].[dbo].[PointsTransactions] pt WITH (NOLOCK) ON pt.[sourceId] = survey.id AND pt.[PanelistId] = panelists.[Id] AND pt.[Source] = 0
        LEFT JOIN ['' + @surveyDatabase + ''].[dbo].VSM_fn_GetUserPermissions(@userId) perm
            ON perm.ObjectId = survey.Id AND ((ISNULL(perm.AllowedPermissions,0) & 1)=1 AND (ISNULL(perm.DeniedPermissions,0) & 1)=0 AND perm.ObjectTypeId IN (2,3))
        WHERE ps.[PanelId] = @panelId
            AND (@showInactive=1 OR survey.Status=3)
            AND (['' + @surveyDatabase + ''].[dbo].VSM_IsUserAdministrator(@userId) = 1 OR perm.ObjectId IS NOT NULL)''

    EXEC sp_executesql @stmt, N''@panelId int, @showInactive bit, @userId int'', @panelId, @showInactive, @userId
END
'

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)

declare @AllDone bit = 0, 
        @TotalPanelClients int, 
		@PanelClientCounter int, 
		@ThisPanelClient nvarchar(128), 
		@PanelClientCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalPanelClients = 0, @PanelClientCounter = 0
	insert into #DB 
	select 'A4Panel_Client_' + cast(Id as nvarchar(16)), 0 
	       from Acuity4.dbo.Client
	       where DB_ID( 'A4Panel_Client_' + cast(Id as nvarchar(16)) ) IS NOT NULL

    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Panel_Client_Template', 0)

	select @TotalPanelClients = count(*) 
	       from #DB

	set @PanelClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @PanelClientCursor
	fetch next from @PanelClientCursor into @ThisPanelClient
	while @@FETCH_STATUS = 0 begin
		select @PanelClientCounter += 1
		select @DBSQL = @ThisPanelClient + N'.sys.sp_executesql'
		select @StatusMessage = 'Updating panel client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @PanelClientCounter / @TotalPanelClients
		raiserror (@StatusMessage, 0, 1, @ThisPanelClient, @PanelClientCounter, @TotalPanelClients, @StatusPercent) with nowait
		
		print 'Panel Client Payload 1'
		select @SQL = replace(replace(@PanelClientPayload01, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 2'
		select @SQL = replace(replace(@PanelClientPayload02, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 3'
		select @SQL = replace(replace(@PanelClientPayload03, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 4'
		select @SQL = replace(replace(@PanelClientPayload04, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 5'
		select @SQL = replace(replace(@PanelClientPayload05, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 6'
		select @SQL = replace(replace(@PanelClientPayload06, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 7'
		select @SQL = replace(replace(@PanelClientPayload07, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 8'
		select @SQL = replace(replace(@PanelClientPayload08, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'All Panel Client Payload done for panel client ' + @ThisPanelClient + '!'

		update #DB set Processed = 1 where current of @PanelClientCursor
		fetch next from @PanelClientCursor into @ThisPanelClient
	end


	close @PanelClientCursor
	deallocate @PanelClientCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Panel_Client_Template';
      SET @SQL = 'USE A4Panel;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

    SELECT @AllDone = 1
end



--select * from #DB
--select * from #Survey

drop table #DB
